# Splashtop Streamer (RPM, AMD64)

## Prerequisite I - EPEL
Please refer to the following website to install EPEL (Extra Packages for Enterprise Linux):
https://docs.fedoraproject.org/en-US/epel/

#### CentOS Stream 9

    sudo dnf config-manager --set-enabled crb
    sudo dnf install epel-release epel-next-release

#### RHEL 9

    sudo subscription-manager repos --enable codeready-builder-for-rhel-9-$(arch)-rpms
    sudo dnf install https://dl.fedoraproject.org/pub/epel/epel-release-latest-9.noarch.rpm

#### AlmaLinux 9, Rocky Linux 9

    sudo dnf config-manager --set-enabled crb
    sudo dnf install epel-release

#### RHEL 8

    sudo subscription-manager repos --enable codeready-builder-for-rhel-8-$(arch)-rpms
    sudo dnf install https://dl.fedoraproject.org/pub/epel/epel-release-latest-8.noarch.rpm

#### AlmaLinux 8, Rocky Linux 8

    sudo dnf config-manager --set-enabled powertools
    sudo dnf install epel-release

#### RHEL 7

    sudo subscription-manager repos --enable rhel-*-optional-rpms \
                               --enable rhel-*-extras-rpms \
                               --enable rhel-ha-for-rhel-*-server-rpms
    sudo yum install https://dl.fedoraproject.org/pub/epel/epel-release-latest-7.noarch.rpm

#### CentOS 7
NOTE: On 2024-06-30, CentOS Linux 7 reached End of Life (EOL) and yum repo has been removed. Before proceeding, apply [CentOS 7 EOL Repository Fix](https://github.com/AtlasGondal/centos7-eol-repo-fix/) if necessary.

    sudo yum install epel-release

## Prerequisite II - `usbip-core.ko` and `vhci-hcd.ko`
USB Device Redirection requires Linux kernel modules `usbip-core.ko` and `vhci-hcd.ko`, they are provided by extra packages.

#### Fedora 39/40
Install `kernel-modules-extra` package

    sudo dnf install kernel-modules-extra

#### Enterprise Linux (RHEL, Rocky Linux, AlmaLinux, CentOS Stream)
Install `kmod-usbip` from [ELRepo](https://elrepo.org)

##### 1. Import the ELRepo public key:

    sudo rpm --import https://www.elrepo.org/RPM-GPG-KEY-elrepo.org


##### 2. Install ELRepo rpm
###### For Enterprise Linux 8 (RHEL 8, Rocky Linux 8, AlmaLinux 8):

    sudo dnf install https://www.elrepo.org/elrepo-release-8.el8.elrepo.noarch.rpm

###### For Enterprise Linux 9 (RHEL 9, Rocky Linux 9, AlmaLinux 9, CentOS 9 Stream):

    sudo dnf install https://www.elrepo.org/elrepo-release-9.el9.elrepo.noarch.rpm

##### 3. Install kmod-usbip:

    sudo dnf install kmod-usbip

##### CentOS 7/RHEL 7
[ELRepo](https://elrepo.org) for CentOS 7/RHEL 7 is removed after EOL, download `kmod-usbip-1.0.1-4.el7_7.elrepo.x86_64.rpm` from one of the mirror sites:

https://repo.nrg.wustl.edu/ELrepo/archive/elrepo/el7/x86_64/RPMS/kmod-usbip-1.0.1-4.el7_7.elrepo.x86_64.rpm

http://ftp.scientificlinux.org/linux/elrepo/archive/elrepo/el7/x86_64/RPMS/kmod-usbip-1.0.1-4.el7_7.elrepo.x86_64.rpm


    sudo yum install ./kmod-usbip-1.0.1-4.el7_7.elrepo.x86_64.rpm

## Install

    sudo yum install ./Splashtop_Streamer_CentOS_x86_64.rpm

## Show command line usage

    splashtop-streamer help

## Deploy

    splashtop-streamer deploy $DEPLOYMENT_CODE

## Show configuration options

    splashtop-streamer config

## Uninstall

    sudo yum remove splashtop-streamer

## SRStreamer.service
### Status

    systemctl status SRStreamer.service

### Start

    sudo systemctl start SRStreamer.service

OR

    sudo service SRStreamer start

### Stop

    sudo systemctl stop SRStreamer.service

OR

    sudo service SRStreamer stop


## Troubleshooting
### NTLM proxy failure
#### OS
Fedora Linux 37+

#### Symptoms
Failed to apply manual proxy settings on GUI

#### Root cause
Starting with Fedora 37 libcurl-minimal is installed by default which does not support NTLM

[# Changes/CurlMinimal as Default](https://fedoraproject.org/wiki/Changes/CurlMinimal_as_Default)

[# Fedora considers curl-minimal](https://lwn.net/Articles/887313/)

#### Fix
Replace libcurl-minimal with libcurl

	$ sudo dnf swap libcurl-minimal libcurl -y